
rm(list = ls())

library("nleqslv")
library("readxl")
library("dplyr")
library("openxlsx")

options(scipen=999)
nombre_export = "b. Piedecuesta SociedadTV.xlsx"

C_IV <- read_excel("../../Bases de datos/b. Coeficientes_IV.xlsx")
observado <- read_excel("../../Bases de datos/Observado.xlsx")
observado <- filter(observado, ID_MUNICIPIO == "68547")

observado <- observado %>%
  mutate(orden = ifelse(ID_EMPRESA=="900092385", 1,
                        ifelse(ID_EMPRESA=="830122566", 2,
                               ifelse(ID_EMPRESA=="900276649",3,NA)))) %>%
  arrange(orden) %>%
  mutate(int = 1, FECHA = 1,
         ID_MUNICIPIO = 1,
         d_Tigo = ifelse(ID_EMPRESA=="900092385",1,0),
         d_Movistar = ifelse(ID_EMPRESA=="830122566",1,0),
         d_SociedadTV = ifelse(ID_EMPRESA=="900276649",1,0),
         d_Comcel = ifelse(ID_EMPRESA=="800153993",1,0))
observado <- observado[-5,]

n_obs<- as.numeric(nrow(observado))
caracteristicas_obs <- as.matrix(select(observado, int, FECHA, ID_MUNICIPIO, VEL_BAJ, TEC_FIBRA, d_Tigo, d_Movistar, d_SociedadTV, d_Comcel))
precios_obs <- as.matrix(select(observado, P))
participaciones_obs <- as.matrix(select(observado, SH))

caracteristicas_integracion <- caracteristicas_obs
caracteristicas_integracion[1,4] <- (observado$SH[1]*caracteristicas_obs[1,4]+observado$SH[2]*caracteristicas_obs[2,4])/(observado$SH[1]+observado$SH[2])
caracteristicas_integracion[2,4] <- (observado$SH[1]*caracteristicas_obs[1,4]+observado$SH[2]*caracteristicas_obs[2,4])/(observado$SH[1]+observado$SH[2])
caracteristicas_integracion[1,5] <- (observado$SH[1]*caracteristicas_obs[1,5]+observado$SH[2]*caracteristicas_obs[2,5])/(observado$SH[1]+observado$SH[2])
caracteristicas_integracion[2,5] <- (observado$SH[1]*caracteristicas_obs[1,5]+observado$SH[2]*caracteristicas_obs[2,5])/(observado$SH[1]+observado$SH[2])
caracteristicas_integracion[2,6] <- 1
caracteristicas_integracion[2,7] <- 0

alpha_est <- 0.030494634302
beta_est <- c(1.966779830085, 0, 0.1784163, -0.000005175567, 1.163681, -0.09059372, -1.493424, 0.5922082, -0.4338529)

empresa <- c("TIGO-UNE", "MOVISTAR", "SOCIEDADTV", "COMCEL")

f_elasticidades <- function(alpha, sharesobs, precios){
  N <- as.numeric(nrow(precios))
  r_elasticidad <- matrix(data=NA, ncol=N, nrow=N)
  for(i in 1:N){
    for(j in 1:N){
      r_elasticidad[i,j] <- (alpha*precios[j])*sharesobs[j]
    }
  }
  diag(r_elasticidad) <- -alpha*precios*(1-sharesobs)
  return(r_elasticidad)
}

f_costosm_equilibrio <- function(elasticidades, precios){
  N <- as.numeric(nrow(precios))
  r_costos <- (1+1/diag(elasticidades))*precios
  colnames(r_costos) <- c("Costos estimados")
  return(r_costos)
}

f_participaciones_est <- function(alpha, beta, caracteristicas, precios){
  N <- as.numeric(nrow(precios))
  V <- matrix(data=NA, ncol=1, nrow=N)
  for(j in 1:N){
    V[j,1] <- exp(as.numeric(caracteristicas[j,]%*%beta)-as.numeric(alpha*precios[j,1]))
  }
  r_participaciones <- matrix(data=NA, ncol=1, nrow=N)
  denominador <- 1+sum(V)
  r_participaciones <- (1/denominador)*V
  return(r_participaciones)
}

f_condiciones_eq <- function(input){
  N <- n_obs
  precios_input <- input[1:N]
  participaciones_input <- input[(N+1):(2*N)]
  c_integradas <- c()
  c_integradas[1] <- 1+((precios_input[1]-as.numeric(costos_est[1,1])))*(-alpha_est*(1-participaciones_input[1]))+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])
  c_integradas[2] <-1+((precios_input[2]-as.numeric(costos_est[2,1])))*(-alpha_est*(1-participaciones_input[2]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])
  c_competidores <- costos_est-precios_input*(1-1/(alpha_est*(1-participaciones_input)*precios_input))
  c_competidores <- c_competidores[-c(1:2),]
  c_participaciones <- participaciones_input-f_participaciones_est(alpha=alpha_est,
                                                                   beta=beta_est,
                                                                   caracteristicas = caracteristicas_integracion,
                                                                   precios=as.matrix(precios_input))

  ajuste <- rbind(as.matrix(c_integradas),as.matrix(c_competidores), as.matrix(c_participaciones))
  return(ajuste)
}

f_condiciones_eq_coordinado <- function(input){
  N <- n_obs
  precios_input <- input[1:N]
  participaciones_input <- input[(N+1):(2*N)]
  c_integradas <- c()
  c_integradas[1] <- 1+((precios_input[1]-as.numeric(costos_est[1,1])))*(-alpha_est*(1-participaciones_input[1]))+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])+
    (precios_input[3]-as.numeric(costos_est[3,1]))*(alpha_est*participaciones_input[3])
  c_integradas[2] <-1+((precios_input[2]-as.numeric(costos_est[2,1])))*(-alpha_est*(1-participaciones_input[2]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])+
    (precios_input[3]-as.numeric(costos_est[3,1]))*(alpha_est*participaciones_input[3])
  c_integradas[3] <-1+((precios_input[3]-as.numeric(costos_est[3,1])))*(-alpha_est*(1-participaciones_input[3]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])
  c_competidores <- costos_est-precios_input*(1-1/(alpha_est*(1-participaciones_input)*precios_input))
  c_competidores <- c_competidores[-c(1:3),]
  c_participaciones <- participaciones_input-f_participaciones_est(alpha=alpha_est,
                                                                   beta=beta_est,
                                                                   caracteristicas = caracteristicas_integracion,
                                                                   precios=as.matrix(precios_input))

  ajuste <- rbind(as.matrix(c_integradas),as.matrix(c_competidores), as.matrix(c_participaciones))
  return(ajuste)
}

f_beneficios <- function(precios, costos, shares){
  beneficios <- (precios-costos)*shares
  colnames(beneficios) <- c("Beneficios")
  return(beneficios)
}

precio_mercado_obs <- as.numeric(precios_obs[,1]%*%participaciones_obs[,1])

elas_est<- f_elasticidades(alpha=alpha_est, sharesobs=participaciones_obs, precios=precios_obs)
rownames(elas_est) <- empresa
colnames(elas_est) <- empresa
elas_est

participaciones_est <- f_participaciones_est(alpha=alpha_est, beta=beta_est, caracteristicas = caracteristicas_obs, precios=precios_obs)
rownames(participaciones_est) <- empresa
participaciones_est

costos_iniciales <- f_costosm_equilibrio(elasticidades = elas_est, precios=precios_obs)
rownames(costos_iniciales) <- empresa
costos_iniciales

beneficios_obs <- f_beneficios(precios=precios_obs,
                               costos = costos_iniciales,
                               shares = participaciones_obs)

costo_eficiencia <- costos_iniciales
coef_eficiencia <- 0.993
coef_sinergia <- observado$SH[1]/(observado$SH[1]+observado$SH[2])
costo_eficiencia[c(1,2),] <-coef_eficiencia*(coef_sinergia*costo_eficiencia[1,]+(1-coef_sinergia)*costo_eficiencia[2,])
costos_est <- costo_eficiencia
costos_est

condiciones_iniciales <- rbind(precios_obs, participaciones_obs)

equilibrio <-  nleqslv(x=condiciones_iniciales, fn=f_condiciones_eq)
equilibrio$x
sum(equilibrio$x[(n_obs+1):(2*n_obs)])

precios_integracion <- equilibrio$x[1:n_obs]
participaciones_integracion <- equilibrio$x[(n_obs+1):(2*n_obs)]

precio_mercado_integracion <- as.numeric(precios_integracion%*%participaciones_integracion)

beneficios_integracion <- f_beneficios(precios=precios_integracion,
                                       costos=costos_est,
                                       shares=participaciones_integracion)

equilibrio_coordinado <-  nleqslv(x=condiciones_iniciales, fn=f_condiciones_eq_coordinado)
equilibrio_coordinado$x
sum(equilibrio_coordinado$x[(n_obs+1):(2*n_obs)])

precios_colusion <- equilibrio_coordinado$x[1:n_obs]
participaciones_colusion <- equilibrio_coordinado$x[(n_obs+1):(2*n_obs)]

precio_mercado_colusion <- as.numeric(precios_colusion%*%participaciones_colusion)

beneficios_colusion <- f_beneficios(precios=precios_colusion,
                                    costos=costos_est,
                                    shares=participaciones_colusion)

precios_traicion <- precios_colusion
precios_traicion[1:2] <- precios_integracion[1:2]
participaciones_traicion <- f_participaciones_est(alpha=alpha_est,
                                                  beta=beta_est,
                                                  caracteristicas = caracteristicas_integracion,
                                                  precios=as.matrix(precios_traicion))

precio_mercado_traicion <- as.numeric(precios_traicion%*%participaciones_traicion)

beneficios_traicion <- f_beneficios(precios=precios_traicion, costos=costos_est, shares=participaciones_traicion)

delta <- (beneficios_traicion[1]-beneficios_colusion[1])/(beneficios_traicion[1]-beneficios_integracion[1])
delta

precios_traicion_2 <- precios_colusion
precios_traicion_2[3] <- precios_integracion[3]
participaciones_traicion_2 <- f_participaciones_est(alpha=alpha_est,
                                                    beta=beta_est,
                                                    caracteristicas = caracteristicas_integracion,
                                                    precios=as.matrix(precios_traicion_2))

precio_mercado_traicion_2 <- as.numeric(precios_traicion_2%*%participaciones_traicion_2)

beneficios_traicion_2 <- f_beneficios(precios=precios_traicion_2, costos=costos_est, shares=participaciones_traicion_2)
delta_2 <- (beneficios_traicion_2[3]-beneficios_colusion[3])/(beneficios_traicion_2[3]-beneficios_integracion[3])
delta_2

escenarios <- c("Observado","Integración", "Colusión", "Traición", "Traición_2")
resumen_beneficios <- cbind(beneficios_obs,
                            beneficios_integracion,
                            beneficios_colusion,
                            beneficios_traicion,
                            beneficios_traicion_2)
resumen_beneficios[2,(2:5)] <- NA
resumen_beneficios[1,2] <- 2*resumen_beneficios[1,2]
resumen_beneficios[1,3] <- 2*resumen_beneficios[1,3]
resumen_beneficios[1,4] <- 2*resumen_beneficios[1,4]
resumen_beneficios[1,5] <- 2*resumen_beneficios[1,5]
colnames(resumen_beneficios) <- escenarios
rownames(resumen_beneficios) <- empresa
resumen_beneficios

resumen_precios <- cbind(precios_obs,
                         precios_integracion,
                         precios_colusion,
                         precios_traicion,
                         precios_traicion_2)
resumen_precios[2,(2:5)] <- NA
colnames(resumen_precios) <- escenarios
rownames(resumen_precios) <- empresa
resumen_precios

resumen_participaciones <- cbind(participaciones_obs,
                                 participaciones_integracion,
                                 participaciones_colusion,
                                 participaciones_traicion,
                                 participaciones_traicion_2)
resumen_participaciones[2,(2:5)] <- NA
resumen_participaciones[1,2] <- 2*resumen_participaciones[1,2]
resumen_participaciones[1,3] <- 2*resumen_participaciones[1,3]
resumen_participaciones[1,4] <- 2*resumen_participaciones[1,4]
resumen_participaciones[1,5] <- 2*resumen_participaciones[1,5]
colnames(resumen_participaciones) <- escenarios
rownames(resumen_participaciones) <- empresa
resumen_participaciones

impacto_precio_integracion <- (precio_mercado_integracion/precio_mercado_obs-1)*100
impacto_precio_colusion <- (precio_mercado_colusion/precio_mercado_obs-1)*100
impacto_precio_traicion <- (precio_mercado_traicion/precio_mercado_obs-1)*100
resumen_impacto_precio <- cbind(impacto_precio_integracion,
                                impacto_precio_colusion)
colnames(resumen_impacto_precio) <- escenarios[2:3]
resumen_impacto_precio

utilidad_obs_p <- participaciones_obs[,1] %*% (-alpha_est*precios_obs)
utilidad_obs_caracteristicas <- participaciones_obs[,1] %*% (caracteristicas_obs%*%beta_est)
utilidad_obs <- utilidad_obs_p + utilidad_obs_caracteristicas

utilidad_integracion_p <- participaciones_integracion %*% (-alpha_est*precios_integracion)
utilidad_integracion_caracteristicas <- participaciones_integracion %*% (caracteristicas_integracion%*%beta_est)
utilidad_integracion <- utilidad_integracion_p + utilidad_integracion_caracteristicas

utilidad_colusion_p <- participaciones_colusion %*% (-alpha_est*precios_colusion)
utilidad_colusion_caracteristicas <- participaciones_colusion %*% (caracteristicas_integracion%*%beta_est)
utilidad_colusion <- utilidad_colusion_p + utilidad_colusion_caracteristicas

resumen_bienestar <- matrix(c(utilidad_obs_p, utilidad_integracion_p, utilidad_colusion_p, utilidad_obs_caracteristicas, utilidad_integracion_caracteristicas, utilidad_colusion_caracteristicas, utilidad_obs, utilidad_integracion, utilidad_colusion), nrow = 3, byrow = TRUE)
colnames(resumen_bienestar) <- escenarios[1:3]
rownames(resumen_bienestar) <- c("Utilidad Precios", "Utilidad Características", "Utilidad Total")
resumen_bienestar

impacto_bienestar_integracion <- ((utilidad_integracion/utilidad_obs)-1)*100
impacto_bienestar_colusion <- ((utilidad_colusion/utilidad_obs)-1)*100

resumen_bienestar_2 <- cbind(impacto_bienestar_integracion, impacto_bienestar_colusion)
colnames(resumen_bienestar_2) <- c(escenarios[2:3])
resumen_bienestar_2

resumen_costos <- cbind(costos_iniciales, costos_est)
colnames(resumen_costos) <- c(escenarios[1:2])
resumen_costos

resumen_delta <- matrix(c(delta, delta_2))
rownames(resumen_delta) <- c('INTEGRACIÓN', 'Líder')
colnames(resumen_delta) <- 'δ'
resumen_delta

resumen_promedios <- colMeans(resumen_precios, na.rm=T)
resumen_promedios <- rbind(resumen_promedios, colMeans(resumen_beneficios, na.rm=T))
resumen_promedios <- rbind(resumen_promedios, c(resumen_bienestar[3, ], rep(NA, 2)))
rownames(resumen_promedios) <- c('Precios promedio', 'Beneficios promedio', 'Bienestar del consumidor')
resumen_promedios

lista_hojas <- list(
  Elasticidades = round(as.data.frame(elas_est), 2),
  Costos = round(as.data.frame(resumen_costos), 2),
  Precios = round(as.data.frame(resumen_precios), 2),
  Participaciones = round(as.data.frame(resumen_participaciones), 4),
  Beneficios = round(as.data.frame(resumen_beneficios), 2),
  Bienestar = round(as.data.frame(resumen_bienestar), 2),
  Delta = round(as.data.frame(resumen_delta), 2),
  Promedios = round(as.data.frame(resumen_promedios), 2)
)

wb <- createWorkbook()

for (nombre in names(lista_hojas)) {
  addWorksheet(wb, nombre)
  writeData(wb, nombre, x = lista_hojas[[nombre]], rowNames = TRUE)
}

estilo_pct <- createStyle(numFmt = "0.00%")
addStyle(wb, sheet = "Participaciones", style = estilo_pct,
         rows = 2:6, cols = 2:6, gridExpand = TRUE)

saveWorkbook(wb, file = nombre_export, overwrite = T)
